from fleming.system_test.fle_sys import *

# Barcodereader-Test Functions
# Last Change: 2021-11-26/Kay Struebing
# New Interface
# - bcr_scan
# - get_datafile

# Global Constants
#INSTRUMENT = "hostname"
PATH, SCRIPT = os.path.split(__file__)
BASE_NAME = SCRIPT.split('.')[0]

# Barcode-Positions scantable

plate_bc = {
    'left'  : {'bcr_nr' : 1, 'pos_x' : 8, 'pos_y' : 176 },
    'rear'  : {'bcr_nr' : 2, 'pos_x' : 8, 'pos_y' : 176 },    
    'right' : {'bcr_nr' : 3, 'pos_x' : 116 , 'pos_y' : 90},
    'front' : {'bcr_nr' : 4, 'pos_x' : 8, 'pos_y' : 5 },
}

ap_bc_pos = {
    'std' : {'pos_x' : 81.0 , 'pos_y' : 179},
    'us' : {'pos_x' : 123.0, 'pos_y' : 178 },
}

async def read_plate_bc(position):
    # [ ] tested 
    # Last modified: 2021-11-26/kstruebing

    # position = left, rear, right, front
    if position not in plate_bc:
        return('No valid position')
    nr = plate_bc[position]['bcr_nr']
    scan_table = VUnits.instance.hal.scan_table
    try:
        bc = await scan_table.ReadPlateBarcode(nr)
        return(f'Plate Barcode: {bc}')
        
    except Exception as ex:
        await send_msg(json.dumps({"result": ex}))
        return('BCR Scan failed')


async def read_fm_bc():
    # [x] tested 
    # Last modified: 2021-11-26/kstruebing

    filter_slider = VUnits.instance.hal.filterModuleSlider
    try:
        bc_string = await filter_slider.ReadCurrentBarcode()
        #bc_string = bytes(raw_bc).decode('utf-8')
        return(f"Filter Module Barcode: {bc_string}")
        
    except Exception as ex:
        await send_msg(json.dumps({"result": ex}))
        return('BCR Scan failed')


async def read_fm_id():
    # [x] tested 
    # Last modified: 2021-11-26/kstruebing
    filter_slider = VUnits.instance.hal.filterModuleSlider
    bc = await filter_slider.ReadCurrentBarcode()
    if bc == '':
        return('noBC')
    if "VACANT" in bc :
        return('noFM')
    return(bc[-4:])

async def fm_bc_scan():
    # [x] tested 
    # Last modified: 2021-05-12/kstruebing
    filter_slider = VUnits.instance.hal.filterModuleSlider
    fm_id = []
    pre_home_pos = 2
    await filter_slider.Home()
    await filter_slider.UseProfile(1)
    for i in range(6): 
        await filter_slider.Move(23.2 + (i) * 24)      
        #bc = await read_fm_bc()
        id = await read_fm_id()
        fm_id.append(id)
        await send_msg(json.dumps({"result": f'Position: {i}, ID: {id}'}))
    await filter_slider.Move(pre_home_pos)
    await filter_slider.Home()    
    return(fm_id)

'''
async def filter_module_bcr_test(cycles = 10):
    result = []
    re_valid_id = r"\d{4}"
    for i in range(cycles):
        result.append(await fm_bc_scan())
    for j in range(cycles):
        result.append(len(re.findall(id_pattern, fm[i]))
'''

async def st_move(pos_x, pos_y):
    scan_table = VUnits.instance.hal.scan_table
    await scan_table.UseProfile(1)
    await scan_table.Move(pos_x, pos_y)

# Module Test

# 2021-06-24 adopted from Teemu
# 2021-06-25 pep8 modifications, datafile
async def plate_bc_scan(start_x = 4.0, start_y = 170.0, stop_x = 12.0, stop_y = 180.0, step_size = 0.5, bcr = 1):
    TEST_NAME = 'plate_bc_scan'
    scan_table = VUnits.instance.hal.scan_table
    await scan_table.Home()
    filename = get_datafile(PATH, BASE_NAME, TEST_NAME)


    bc_data = dict()

    x = start_x
    y = start_y
    msg = f"{TEST_NAME} started "
    await send_msg(json.dumps({"result": msg}))
    while x <= stop_x:
        while y <= stop_y:
            await scan_table.Move(x, y)
            curr_bc = await scan_table.ReadPlateBarcode(bcr)
            await send_msg(json.dumps({"result": curr_bc}))
            bc_data[(x, y)] = curr_bc
            y = y + step_size
        x = x + step_size
        y = start_y
    with open(filename, 'a') as file:

        x = start_x

        curr_line = "\t"
        while x <= stop_x:
            curr_line = curr_line + str(x) + "\t"
            x = x + step_size

        file.write(curr_line + "\n")
        await send_msg(json.dumps({"result": curr_line}))

        x = start_x
        y = start_y

        while y <= stop_y:
            curr_line = str(y) + "\t"
            while x <= stop_x:
                curr_line = curr_line + bc_data[(x, y)] + "\t"
                x = x + step_size
            file.write(curr_line + "\n")
            await send_msg(json.dumps({"result": curr_line}))
            y = y + step_size
            x = start_x
    msg = f"{TEST_NAME} stopped, result written to {filename}"
    await send_msg(json.dumps({"result": msg}))

async def fm_bc_test(num_of_fm = 6, scan_range = 2, step = 0.1):
    # [x] tested 
    # Last modified: 2021-05-12/kstruebing
    # Barcodereader Test acc. to FLE-1681
    TEST_NAME = 'fm_bc_test'
    #filename = get_datafile(TEST_NAME)
    await send_msg(json.dumps({"result": f'{TEST_NAME} started.'}))
    fbd = VUnits.instance.hal.filterModuleSlider
    await fbd.Home()
    await fbd.UseProfile(1)
    await send_msg(json.dumps({"result": f'Module;Pos;Barcode'}))
    for p in range(num_of_fm):
        await fm_bc_single_scan(p, scan_range, step)
#        with open(filename, 'a') as file:
#            line = f'{i};{position};{bc}\n'
#            file.write(line)

async def fm_bc_single_scan(fm = 0, scan_range = 2, step = 0.1):
    # [x] tested 
    # Last modified: 2021-05-12/kstruebing
    # Barcodereader Test acc. to FLE-1681
    fm_0_pos = 22.2
    fm_rel_pos = 24.0
    scan_steps = int( scan_range / step )
    fbd = VUnits.instance.hal.filterModuleSlider
    start_pos = fm_0_pos + (fm * fm_rel_pos) - scan_range / 2.0
    for s in range (int(scan_steps)):
        position = start_pos + s * step
        await fbd.Move(position)
        bc = await read_fm_id()
        await send_msg(json.dumps({"result": f'{fm};{position:0.2f}; {bc}'}))
        if GlobalVar.get_stop_gc():
            await fbd.Home()
            PyLogger.logger.error("gc_predefined_tasks> Script stopped by user")
            await send_msg(json.dumps({"result": f"Script stopped by user"}))
            return "Stopped by user"
    
